% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R
\name{append}
\alias{append}
\alias{append.ldat}
\alias{append.lvec}
\title{Append a vector to an lvec}
\usage{
append(x, y, ...)

\method{append}{lvec}(x, y, clone = TRUE, ...)

\method{append}{ldat}(x, y, clone = TRUE, ...)
}
\arguments{
\item{x}{\code{\link{lvec}} to append to.}

\item{y}{vector to append to \code{x}. Is converted to \code{\link{lvec}}
using \code{\link{as_lvec}}.}

\item{...}{ignored; used to pass additional arguments to other methods.}

\item{clone}{should \code{x} be cloned first. If not, the input \code{x} is
modified.}
}
\value{
Returns an lvec combining both \code{x} and \code{y}. When \code{x} is 
\code{NULL} a clone of \code{y} is returned.
}
\description{
Append a vector to an lvec
}

