% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{CoefTable}
\alias{CoefTable}
\title{Extract Coefficients from a list of \code{ldtestim} object}
\usage{
CoefTable(
  list,
  depInd = 1,
  regInfo = list(c("", " "), c("num_obs", "No. Obs."), c("num_eq", "No. Eq."), c("num_x",
    "No. Exo."), c("sigma2", "S.E. Reg."), c("aic", "AIC"), c("sic", "SIC")),
  hnameFun = function(x) x,
  vnamesFun = function(x) x,
  vnamesFun_sub = list(c("\%", "\\\\\\\\\%"), c("_", "\\\\\\\\_")),
  vnamesFun_max = 20,
  tableFun = "coef_star",
  formatNumFun = function(colIndex, x) {
     x
 },
  numCoefs = NA,
  formatLatex = TRUE
)
}
\arguments{
\item{list}{a named list of \code{ldtestim} objects.}

\item{depInd}{index of the dependent variable.}

\item{regInfo}{A list of pairs of keys and names to determine
the information at the bottom of the table. Use "" (empty) for
empty rows. \code{num_eq} and \code{num_endo} (and \code{num_x} and
\code{num_exo}) will be different with PCA analysis enabled.}

\item{hnameFun}{A function to change the name of the headers.}

\item{vnamesFun}{A function to change the name of the variables or the codes in \code{regInfo}.}

\item{vnamesFun_sub}{A list for replacing special characters vectors in \code{vnamesFun}.}

\item{vnamesFun_max}{Maximum length for names in \code{vnamesFun}.}

\item{tableFun}{A function (i.e., \code{function(coef,std,pvalue,minInColm,maxInCol)})
one of the following for default sign or coefficients table: "sign",
"sign_star", "coef", "coef_star", "coef_star_std"}

\item{formatNumFun}{A function to format the numbers if \code{tableFun} uses default values.}

\item{numCoefs}{if \code{NA}, it inserts all coefficients. If a positive number,
it inserts that number of coefficients.}

\item{formatLatex}{If true, default options are for 'latex', otherwise, 'html'.}
}
\value{
the generated table.
}
\description{
Extract Coefficients from a list of \code{ldtestim} object
}
\details{
#' Possible codes (first element) for \code{regInfo}:
\itemize{
\item "" : empty line
\item num_obs : No. Obs.; number of observations.
\item num_endo : No. Eq. (orig.); original number of equations
or endogenous variables before being changed by PCA analysis.
\item pca_y_exact : PCA Count (y);
\item pca_y_cutoff : PCA Cutoff (y)
\item pca_y_max : PCA Max (y)
\item num_eq : No. Eq.; number of equations after PCA analysis.
\item num_exo : No. Exo. (orig.)
\item pca_x_exact : PCA Count (x)
\item pca_x_cutoff : PCA Cutoff (x)
\item pca_x_max : PCA Max (x)
\item num_x : No. Exo.
\item num_x_all : No. Exo. (all); number of explanatory variables in all equations.
\item num_rest : No. Rest.; number of restrictions in the equation
\item sigma2 : S.E. Reg.
\item ... others can be a measure name (i.e., elements of 'measures' item in the results)
}
}
