% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{F_DailyInWeek}
\alias{F_DailyInWeek}
\title{Creates an \code{Daily-In-Week} Frequency}
\usage{
F_DailyInWeek(year, month, day, weekStart, weekEnd, forward)
}
\arguments{
\item{year}{Year of the observation}

\item{month}{Month of the observation}

\item{day}{First day of the observation}

\item{weekStart}{First day of the week. It can be \code{sun}, \code{mon},
\code{tue}, \code{wed}, \code{thu}, \code{fri}, and \code{sat}}

\item{weekEnd}{Last day of the week. See \code{weekStart}.
Together, they define the week}

\item{forward}{If current date in not in the week,
if true, it moves forward to the first day of the week.
Otherwise, it moves backward to the last day of the week.}
}
\value{
An object of class 'ldtf'
}
\description{
Frequency for a series that happens every in the days of a week
}
\details{
\itemize{
\item \strong{Value String:} \code{"YYYYMMDD"} (similar to \code{Weekly})
\item \strong{Class String:} \code{"i:...-..."} (the first ... is \code{weekStart}
and the second ... is \code{weekEnd}; e.g., \code{i:mon-fri} means
a week that is from Monday to Friday)
}
}
