% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetRocOptions}
\alias{GetRocOptions}
\title{Options for ROC and AUC}
\usage{
GetRocOptions(
  lowerThreshold = 0,
  upperThreshold = 1,
  epsilon = 1e-12,
  pessimistic = FALSE,
  costs = NULL,
  costMatrix = NULL
)
}
\arguments{
\item{lowerThreshold}{(double) Lower bound for calculating partial AUC.}

\item{upperThreshold}{(double) Upper bound for calculating partial AUC.}

\item{epsilon}{(double) A value to ignore small floating point differences in comparing scores.}

\item{pessimistic}{(bool) If true, sequences of equally scored instances are treated differently and a pessimistic measure is calculated (see Fawcett (2006) An introduction to roc analysis, fig. 6).}

\item{costs}{(numeric vector) cost of each observations. If null, cost of all observations will be 1.}

\item{costMatrix}{(numeric matrix) a 2x2 cost matrix in which: (1,1) is cost of TN,
(2,2) is cost of TP, (1,2) is cost of FP and (2,1) is cost of FN. First
column is multiplied by the corresponding value in costs vector (see
Fawcett (2006), ROC graphs with instance-varying costs).}
}
\value{
A list with the given options.
}
\description{
Options for ROC and AUC
}
