% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{get.search.items}
\alias{get.search.items}
\title{Specify the Purpose of the Model Search Process}
\usage{
get.search.items(
  model = TRUE,
  type1 = FALSE,
  type2 = FALSE,
  bestK = 1,
  all = FALSE,
  inclusion = FALSE,
  cdfs = numeric(0),
  extremeMultiplier = 0,
  mixture4 = FALSE
)
}
\arguments{
\item{model}{If \code{TRUE}, some information about the models is saved.}

\item{type1}{If \code{TRUE} and implemented, extra information is saved. This can be the coefficients in the SUR search or predictions in the VARMA search.}

\item{type2}{If \code{TRUE} and implemented, extra information is saved. This is similar to \code{type1}. \strong{It is reserved for future updates.}}

\item{bestK}{The number of best items to be saved in \code{model}, \code{type1}, or \code{type2} information.}

\item{all}{If \code{TRUE}, all models' information is saved.}

\item{inclusion}{If \code{TRUE}, inclusion weights are saved.}

\item{cdfs}{Weighted average of the CDFs at each given point is calculated (for \code{type1} and \code{type2} cases).}

\item{extremeMultiplier}{A number that determines the multiplier in the extreme bound analysis (for \code{type1} and \code{type2} cases). Use zero to disable it.}

\item{mixture4}{If \code{TRUE}, the first four moments of the average distributions are calculated in \code{type1} and \code{type2} cases.}
}
\value{
A list with the given options.
}
\description{
Use this function to list the required items and information that should be saved and retrieved from the model set search process in \code{search.?} functions.
}
