% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.roc}
\alias{s.roc}
\title{Get ROC Curve Data for Binary Classification}
\usage{
s.roc(y, scores, weights = NULL, options = get.options.roc())
}
\arguments{
\item{y}{A numeric vector (\code{Nx1}) representing the actual values.}

\item{scores}{A numeric vector (\code{Nx1}) representing the calculated probabilities for the \strong{negative} observations.}

\item{weights}{A numeric vector (\code{Nx1}) representing the weights of the observations.
Use \code{NULL} for equal weights.}

\item{options}{A list from \code{\link{get.options.roc}} function for more options.}
}
\value{
A list with the following items:
\item{n}{Number of observations. }
\item{auc}{Value of AUC. }
\item{points}{Points for plotting ROC.}
}
\description{
This function calculates the required points for plotting the ROC curve and the AUC.
}
\details{
This is generally a statistics helper method in this package and it shows the inner calculations.
See AUC section in \link{get.search.metrics} for a discussion.
}
\examples{
y <- c(1, 0, 1, 0, 1, 1, 0, 0, 1, 0)
scores <- c(0.1, 0.2, 0.3, 0.5, 0.5, 0.5, 0.7, 0.8, 0.9, 1)
res1 <- s.roc(y,scores)
costs <- c(1,2,1,4,1,5,1,1,0.5,1)
costMatrix <- matrix(c(0.02,-1,-3,3),2,2)
opt <- get.options.roc(costs = costs, costMatrix = costMatrix)
res2 <- s.roc(y,scores,NULL,options = opt)
}
