% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.prints.R
\name{coefs.table}
\alias{coefs.table}
\title{Create Table of Coefficients}
\usage{
coefs.table(
  estimList,
  depList = NULL,
  tableFun = "coef_star",
  formatNumFun = NULL,
  regInfo = NULL,
  textFun = NULL,
  textFun_sub = NULL,
  textFun_max = 20,
  expList = NA,
  latex = TRUE,
  numFormat = "\%.2f"
)
}
\arguments{
\item{estimList}{A named list where each element is output from a \code{estim.?} function, all belonging to a common analysis.}

\item{depList}{List of endogenous variable name to be included in the columns of the table. If \code{NULL}, everything is added.}

\item{tableFun}{Function with arguments \code{coef}, \code{std}, \code{pvalue}, \code{minInColm}, \code{maxInCol} for formatting estimated coefficients.
Can also use one of the following character strings for predefined formatting: \code{sign}, \code{sign_star}, \code{coef}, \code{coef_star}, \code{coef_star_std}.}

\item{formatNumFun}{Function to format numbers if \code{tableFun} uses predefined formatting. It takes two arguments: \code{colIndex} (determines the column index) and \code{x} (determines the value).}

\item{regInfo}{List of keys (such as \code{num_eq}, \code{num_dep}, ...) to determine information at bottom of table. Use "" (empty) for empty rows.
A list of available options is given in the details section.}

\item{textFun}{Function to change any text in columns or rows of the table to a more informative text.
It has two arguments: \code{text} and \code{type}.}

\item{textFun_sub}{List for replacing special characters. If \code{NULL}, 'list(c("\%", "\\\\\%"), c("\emph{", "\\\\}"))' is used.}

\item{textFun_max}{Maximum length for texts in the table.}

\item{expList}{Determines the name of the explanatory variables to insert in table.
If \code{NA}, it inserts all coefficients.
If it is an integer, it insert that number of explanatory variables in the table.
It can be a list of available explanatory variables.
Use \code{...} for empty rows.}

\item{latex}{If \code{TRUE}, default options are for 'latex', otherwise, 'html'.}

\item{numFormat}{default formatting for the numbers.}
}
\value{
A data frame with (formatted) requested information.
}
\description{
This function summarizes a list of estimated models (output of \code{estim.?} functions) and creates
a table of coefficients.
}
\details{
The first part of the table is the header, followed by the coefficients. At the bottom, you can insert
the following items by specifying \code{regInfo}:
\itemize{
\item An empty character string (i.e., "") for inserting empty line.
\item \code{"sigma2"} for the covariance of regression, if it is available.
\item An available metric name in the row names of \code{estimList[[...]]$metrics}.
}

Furthermore, second argument in \code{textFun} can be:
\itemize{
\item \code{hname}: shows that the text is a header name from the \code{estimList} elements.
\item \code{dname}: shows that the text is an endogenous variable name from the columns of \code{coefs} matrix.
\item \code{rname}: shows that the text is a key given in \code{regInfo}.
\item \code{ename}: shows that the text is an explanatory variable name from the rows of \code{coefs} matrix.
\item \code{NULL}: shows that the text is a specific code or something else.
}
}
\examples{
# See 'search.?' or 'estim.?' functions for some examples.

}
