% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.regression.R
\name{residuals.ldt.estim}
\alias{residuals.ldt.estim}
\title{Extract Residuals Data}
\usage{
\method{residuals}{ldt.estim}(object, equations = NULL, standardized = FALSE, pearson = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{ldt.estim}.}

\item{equations}{A number, a numeric array or a string array specifying the equations with residual data. If \code{NULL}, residuals in all equations are returned.}

\item{standardized}{If \code{TRUE}, standardized residuals are returned. See details.}

\item{pearson}{If \code{TRUE}, it returns (or uses) Pearson residuals for binary choice regression.}

\item{...}{Additional arguments.}
}
\value{
A matrix containing the residuals data.
}
\description{
This function returns residuals from or calculates the standardized residuals for an \code{ldt.estim} object.
}
\details{
The standardized residuals have identical variance.
In order to calculate the standardized residuals, each residual is divided by \eqn{s\sqrt{w_i(1-h_{ii})}} where \eqn{s} is the standard error of residuals and \eqn{h_{ii}} is the leverage of \eqn{i}-th observation. \eqn{w_i} is the weight of the \eqn{i}-th observation if data is weighted, and 1 otherwise.
Note that while the residuals are estimated in a system, the \eqn{h_{ii}} is calculated in a univariate context as the \eqn{i}-th diagonal of \eqn{X(X'X)^{-1}X'} matrix, where \eqn{X} is the exogenous variables in the corresponding equation.
}
