% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{addLocalFile}
\alias{addLocalFile}
\title{Add vector data to leaflet map directly from the file system}
\usage{
addLocalFile(
  map,
  file,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  label = NULL,
  radius = 10,
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  options = NULL
)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{file}{file path to the file to be added to \code{map}. NOTE: will be
reprojected on-the-fly if not in "longlat".}

\item{layerId}{the layer id.}

\item{group}{the group name for the file to be added to \code{map}.}

\item{popup}{either a logical of whether to show the feature properties
(fields) in popups or the name of the field to show in popups.}

\item{label}{name of the field to be shown as a tooltip.}

\item{radius}{the size of the circle markers.}

\item{stroke}{whether to draw stroke along the path
(e.g. the borders of polygons or circles).}

\item{color}{stroke color.}

\item{weight}{stroke width in pixels.}

\item{opacity}{stroke opacity.}

\item{fill}{whether to fill the path with color
(e.g. filling on polygons or circles).}

\item{fillColor}{fill color.}

\item{fillOpacity}{fill opacity.}

\item{dashArray}{a string that defines the stroke dash pattern.}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements.}
}
\description{
Add vector data to leaflet map directly from the file system
}
\examples{
if (interactive()) {
  library(leafem)
  library(leaflet)
  library(sf)

  destfile = tempfile(fileext = ".gpkg")

  st_write(st_as_sf(gadmCHE), dsn = destfile)

  leaflet() \%>\%
    addTiles() \%>\%
    addLocalFile(destfile, popup = TRUE)
}

}
