% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{addLegendSize}
\alias{addLegendSize}
\alias{sizeNumeric}
\alias{sizeBreaks}
\title{Add a legend that for the sizing of symbols}
\usage{
addLegendSize(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star",
    "stadium"),
  orientation = c("vertical", "horizontal"),
  opacity = 1,
  fillOpacity = opacity,
  breaks = 5,
  baseSize = 10,
  color,
  ...
)

sizeNumeric(values, baseSize)

sizeBreaks(values, breaks, baseSize, ...)
}
\arguments{
\item{map}{a map widget object created from 'leaflet'}

\item{pal}{the color palette function, generated from \link[leaflet]{colorNumeric}}

\item{values}{the values used to generate colors from the palette function}

\item{title}{the legend title, pass in HTML to style}

\item{labelStyle}{character string of style argument for HTML text}

\item{shape}{shape of the color symbols}

\item{orientation}{stack the legend items vertically or horizontally}

\item{opacity}{opacity of the legend items}

\item{fillOpacity}{fill opacity of the legend items}

\item{breaks}{an integer specifying the number of breaks or a numeric vector of the breaks}

\item{baseSize}{re-scaling size in pixels of the mean of the values, the average value will
be this exact size}

\item{color}{the color of the legend symbols, if omitted pal is used}

\item{...}{arguments to pass to \link[leaflet]{addControl}}
}
\value{
an object from \link[leaflet]{addControl}
}
\description{
Add a legend that for the sizing of symbols
}
\examples{
library(leaflet)
data("quakes")
numPal <- colorNumeric('viridis', quakes$depth)
sizes <- sizeNumeric(quakes$depth, baseSize = 10)
symbols <- Map(
  makeSymbol,
  shape = 'triangle',
  color = numPal(quakes$depth),
  width = sizes,
  height = sizes
)
leaflet() \%>\%
  addTiles() \%>\%
  addMarkers(data = quakes,
             icon = icons(iconUrl = symbols),
             lat = ~lat, lng = ~long) \%>\%
  addLegendSize(
    values = quakes$depth,
    pal = numPal,
    title = 'Depth',
    labelStyle = 'margin: auto;',
    shape = c('triangle'),
    orientation = c('vertical', 'horizontal'),
    opacity = .7,
    breaks = 5)
}
