% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basemapLayers.R
\name{addEsriBasemapLayer}
\alias{addEsriBasemapLayer}
\title{Adds a ArcGIS Basemap layer}
\usage{
addEsriBasemapLayer(map, key, autoLabels = FALSE, layerId = NULL,
  group = NULL, options = NULL)
}
\arguments{
\item{map}{The leaflet map}

\item{key}{ID of the layer}

\item{autoLabels}{whether to show corresponding labels layer}

\item{layerId}{Unique ID for the layer}

\item{group}{The group this layer belongs to.}

\item{options}{Basemap Layer Options. You can pass \code{\link[leaflet]{tileOptions}()}.}
}
\description{
Adds a ArcGIS Basemap layer
}
\examples{
\dontrun{
leaflet() \%>\%
   addEsriBasemapLayer(esriBasemapLayers$Oceans, autoLabels=TRUE)
}
}
