% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicMapLayers.R
\name{dynamicMapLayerOptions}
\alias{dynamicMapLayerOptions}
\title{Options for dynamic map layer.}
\usage{
dynamicMapLayerOptions(format = "png24", transparent = TRUE, f = "json",
  attribution = "", layers = NULL, layerDefs = NULL, opacity = 1,
  position = "front", maxZoom = NULL, minZoom = NULL,
  dynamicLayers = NULL, token = NULL, proxy = NULL, useCors = TRUE, ...)
}
\arguments{
\item{format}{Output format of the image.}

\item{transparent}{Allow the server to produce transparent images.}

\item{f}{Server response content type.}

\item{attribution}{Attribution from service metadata copyright text is automatically displayed in Leaflet's default control. This property can be used for customization.}

\item{layers}{An array of Layer IDs like [3,4,5] to show from the service.}

\item{layerDefs}{A string representing a query to run against the service before the image is rendered. This can be a string like "3:STATE_NAME='Kansas'" or an object mapping different queries to specific layers {3:"STATE_NAME='Kansas'", 2:"POP2007>25000"}.}

\item{opacity}{Opacity of the layer. Should be a value between 0 (completely transparent) and 1 (completely opaque).}

\item{position}{Position of the layer relative to other overlays.}

\item{maxZoom}{Closest zoom level the layer will be displayed on the map.}

\item{minZoom}{Furthest zoom level the layer will be displayed on the map.}

\item{dynamicLayers}{JSON object literal used to manipulate the layer symbology defined in the service itself. Requires a 10.1 (or above) map service which supports dynamicLayers requests.}

\item{token}{If you pass a token in your options it will be included in all requests to the service.}

\item{proxy}{URL of an \href{https://developers.arcgis.com/javascript/jshelp/ags_proxy.html}{ArcGIS API for JavaScript proxy} or \href{https://github.com/Esri/resource-proxy}{ArcGIS Resource Proxy} to use for proxying requests.}

\item{useCors}{If this service should use CORS when making GET requests.}

\item{...}{extra options}
}
\description{
Options for dynamic map layer.
}
