% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep.R
\name{suspendScroll}
\alias{suspendScroll}
\title{Prevents accidental map scrolling when scrolling in a document.}
\usage{
suspendScroll(map, sleep = TRUE, sleepTime = 750, wakeTime = 750,
  sleepNote = TRUE, hoverToWake = TRUE,
  wakeMessage = "Click or Hover to Wake", sleepOpacity = 0.7)
}
\arguments{
\item{map}{The leaflet map}

\item{sleep}{false if you want an unruly map}

\item{sleepTime}{time(ms) until map sleeps on mouseout}

\item{wakeTime}{time(ms) until map wakes on mouseover}

\item{sleepNote}{should the user receive wake instructions?}

\item{hoverToWake}{should hovering wake the map? (non-touch devices only)}

\item{wakeMessage}{a message to inform users about waking the map}

\item{sleepOpacity}{opacity for the sleeping map}
}
\description{
Prevents accidental map scrolling when scrolling in a document.
}
\examples{
leaflet(width = "100\%") \%>\%
  setView(0, 0, 1) \%>\%
  addTiles() \%>\%
  suspendScroll()
}
