% Please edit documentation in R/leaflet.R
\name{mapOptions}
\alias{mapOptions}
\title{Set options on a leaflet map object}
\usage{
mapOptions(map, zoomToLimits = c("always", "first", "never"))
}
\arguments{
\item{map}{A map widget object created from \code{\link{leaflet}()}}

\item{zoomToLimits}{Controls whether the map is zooms to the limits of the
  elements on the map. This is useful for interactive applications where the
  map data is updated. If \code{"always"} (the default), the map always
  re-zooms when new data is received; if \code{"first"}, it zooms to the
  elements on the first rendering, but does not re-zoom for subsequent data;
  if \code{"never"}, it never re-zooms, not even for the first rendering.}
}
\description{
Set options on a leaflet map object
}
\examples{
# Don't auto-zoom to the objects (can be useful in interactive applications)
leaflet() \%>\% addTiles() \%>\% addPopups(174.7690922, -36.8523071, "R was born here!") \%>\% 
    mapOptions(zoomToLimits = "first")
}
