% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_model.R
\name{agg_curve}
\alias{agg_curve}
\title{Aggregate Learning Curve}
\usage{
agg_curve(t, r, n, na.rm = FALSE)
}
\arguments{
\item{t}{vector of hours (or costs) for the first unit from departments 1 through m}

\item{r}{vector of historical learning rates for departments 1 through m}

\item{n}{total units to be produced across all departments}

\item{na.rm}{Should \code{NA} values be removed?}
}
\description{
Computes the approximate aggregate cumulative learning curve formula by calculating the sum of all contributing hours from all departments for all production units 1 through n.
}
\examples{

\dontrun{
# A project is expected to get underway soon to produce 300
# widgets. Three departments will be involved. Historically,
# these departments have had learning curves of 85\%, 87\%, and
# 80\% respectively. The first unit hours for these departments
# have been estimated at 70, 45, and 25 respectively. What is 
# the total predicted hours required for the entire effort?

t <- c(70, 45, 25)
r <- c(.85, .87, .8)

agg_curve(t = t, r = r, n = 300)
## [1] 11000.96
}
}

