% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tutorial-format.R
\name{tutorial}
\alias{tutorial}
\title{Tutorial document format}
\usage{
tutorial(
  fig_width = 6.5,
  fig_height = 4,
  fig_retina = 2,
  fig_caption = TRUE,
  progressive = FALSE,
  allow_skip = FALSE,
  dev = "png",
  df_print = "paged",
  smart = TRUE,
  theme = "rstudio",
  highlight = "textmate",
  ace_theme = "textmate",
  mathjax = "default",
  extra_dependencies = NULL,
  css = NULL,
  includes = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  language = "en",
  lib_dir = NULL,
  ...
)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{progressive}{Display sub-topics progressively (i.e. wait until previous
topics are either completed or skipped before displaying subsequent
topics).}

\item{allow_skip}{Allow users to skip sub-topics (especially useful when
\code{progressive} is \code{TRUE}).}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}. See
\href{https://bookdown.org/yihui/rmarkdown/html-document.html#data-frame-printing}{Data
frame printing section} in bookdown book for examples.}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, \code{---} to em-dashes, \code{--} to en-dashes,
and \code{...} to ellipses. Deprecated in \pkg{rmarkdown} v2.2.0.}

\item{theme}{Visual theme ("rstudio", default", "cerulean", "journal",
"flatly", "readable", "spacelab", "united", "cosmo", "lumen", "paper",
"sandstone", "simplex", or "yeti").}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", "haddock", and "textmate". Pass ‘NULL’ to prevent syntax
highlighting.  Note, this value only pertains to standard rmarkdown code,
not the Ace editor highlighting.}

\item{ace_theme}{Ace theme supplied to the ace code editor for all exercises.
See \code{learnr:::ACE_THEMES} for a list of possible values.  Defaults to
\code{"textmate"}.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from a
MathJax CDN. The "local" option uses a local version of MathJax (which is
copied into the output directory). You can pass an alternate URL or pass
\code{NULL} to exclude MathJax entirely.}

\item{extra_dependencies}{Extra dependencies as a list of the
\code{html_dependency} class objects typically generated by
\code{htmltools::\link{htmlDependency}()}.}

\item{css}{CSS and/or Sass files to include. Files with an extension of .sass
or .scss are compiled to CSS via \code{sass::sass()}. Also, if \code{theme} is a
\code{\link[bslib:bs_theme]{bslib::bs_theme()}} object, Sass code may reference the relevant Bootstrap
Sass variables, functions, mixins, etc.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the \code{\link[rmarkdown]{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{language}{Language or custom text of the UI elements. See
\code{vignette("multilang", package = "learnr")} for more information about
available options and formatting}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\code{_files} appended to it.}

\item{...}{Forward parameters to html_document}
}
\value{
An \code{\link[rmarkdown:output_format]{rmarkdown::output_format()}} for \pkg{learnr} tutorials.
}
\description{
Long-form tutorial which includes narrative, figures, videos, exercises, and
questions.
}
\examples{
tutorial()

}
