% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-.R
\name{guide-composition}
\alias{guide-composition}
\alias{new_compose}
\title{Guide composition}
\usage{
new_compose(
  guides,
  args = list(),
  ...,
  available_aes = c("any", "x", "y", "r", "theta"),
  call = caller_env(),
  super = Compose
)
}
\arguments{
\item{guides}{A \verb{<list>} of guides wherein each element is one of the
following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character[1]>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{args}{A \verb{<list>} of arguments to pass to guides that are given either
as a function or as a string.}

\item{...}{Additional parameters to pass on to
\code{\link[ggplot2:new_guide]{new_guide()}}.}

\item{available_aes}{A \verb{<character>} giving aesthetics that must match the
the guides.}

\item{call}{A \link[rlang:topic-error-call]{call} to display in messages.}

\item{super}{A \verb{<Compose>} class object giving a meta-guide for composition.}
}
\value{
A \verb{<Compose>} (sub-)class guide that composes other guides.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Guide composition is a meta-guide orchestrating an ensemble of other guides.
On their own, a 'composing' guide is not very useful as a visual reflection
of a scale.
}
\examples{
# The `new_compose()` function is not intended to be used directly
my_composition <- new_compose(list("axis", "axis"), super = ComposeStack)

# Is the same as
my_composition <- compose_stack("axis", "axis")
}
\seealso{
Other composition: 
\code{\link{compose_crux}()},
\code{\link{compose_ontop}()},
\code{\link{compose_sandwich}()},
\code{\link{compose_stack}()}
}
\concept{composition}
