% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-capped.r
\name{coord_capped_cart}
\alias{coord_capped_cart}
\alias{coord_capped_flip}
\alias{capped_horisontal}
\alias{capped_vertical}
\title{Cartesian coordinates with capped axis lines.}
\usage{
coord_capped_cart(xlim = NULL, ylim = NULL, expand = TRUE,
  top = waiver(), left = waiver(), bottom = waiver(), right = waiver(),
  gap = 0.01)

coord_capped_flip(xlim = NULL, ylim = NULL, expand = TRUE,
  top = waiver(), left = waiver(), bottom = waiver(), right = waiver(),
  gap = 0.01)

capped_horisontal(capped = c("both", "left", "right", "none"), gap = 0.01)

capped_vertical(capped = c("top", "bottom", "both", "none"), gap = 0.01)
}
\arguments{
\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{top, left, bottom, right}{Either a function returned from
\code{\link{capped_horisontal}} or \code{\link{brackets_horisontal}}.
If string, it is assumed to be shorthand for
\code{capped_horisontal(capped)} or similar for vertical.}

\item{gap}{Both ends are \emph{always} capped by this proportion.
Usually a value between 0 and 1.}

\item{capped}{Which end to cap the line. Can be one of (where relevant):
\code{both}, \code{none}, \code{left}, \code{right}, \code{top}, \code{bottom}.}
}
\description{
Caps the axis lines to the outer ticks to e.g. indicate range of values.
Methods correspond to \code{\link{coord_cartesian}} and \code{\link{coord_flip}}
}
\details{
This function is a simple override of \code{\link{coord_flex_cart}}
and \code{\link{coord_flex_flip}},
which allows shorthand specification of what to cap.

NB! A panel-border is typically drawn on top such that it covers tick marks,
grid lines, and axis lines.
Many themes also do not draw axis lines.
To ensure the modified axis lines are visible, use
\code{theme(panel.border=element_blank(), axis.lines=element_line())}.
}
\examples{
library(ggplot2)
# Notice how the axis lines of the following plot meet in the lower-left corner.
p <- ggplot(mtcars, aes(x = mpg)) + geom_dotplot() +
  theme_bw() +
  theme(panel.border=element_blank(), axis.line=element_line())
p

# We can introduce a gap by capping the ends:
p + coord_capped_cart(bottom='none', left='none')

# The lower limit on the y-axis is 0. We can cap the line to this value.
# Notice how the x-axis line extends through the plot when we no long
# define its capping.
p + coord_capped_cart(left='both')

# It it also works on the flipped.
p + coord_capped_flip(bottom='both')

# And on secondary axis, in conjuction with brackets:
p +
  scale_y_continuous(sec.axis = sec_axis(~.*100)) +
  scale_x_continuous(sec.axis = sec_axis(~1/., name='Madness scale')) +
  coord_capped_cart(bottom='none', left='none', right='both', top=brackets_horisontal())
# Although we cannot recommend the above madness.
}
