% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leptokurticMixture.R
\name{rmln}
\alias{rmln}
\title{Generate realizations from the multivariate elliptical leptokurtic-normal distribution}
\usage{
rmln(n = NULL, d = NULL, mu = NULL, Sigma = NULL, beta = NULL)
}
\arguments{
\item{n}{number of observations}

\item{d}{the dimension of the observations}

\item{mu}{location parameter of length d}

\item{Sigma}{(d x d) scatter matrix}

\item{beta}{the concentration parameter}
}
\value{
A (n x d) matrix of realizations
}
\description{
This function calculates the log cumulative density function for the multivariate-t with scale matrix equal to the identity matrix. It finds the mode and then uses Gaussian quadrature to estimate the integral.
}
\examples{
x = rmln(n=10, d=4, mu=rep(0,4), diag(4), beta=2)
}
