## ---------------------------------------------------------------------------------------------------------------------
library("lessR")

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ----fig.width=4.5, fig.height=4.5------------------------------------------------------------------------------------
reg_brief(Salary ~ Years + Pre)

## ---------------------------------------------------------------------------------------------------------------------
reg(Salary ~ Years + Pre)

## ---- fig.width=4.5, fig.height=4-------------------------------------------------------------------------------------
reg_brief(Salary ~ Years, rescale="z", plot_errors=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
reg(Salary ~ Years, kfold=3)

## ---------------------------------------------------------------------------------------------------------------------
r <- reg(Salary ~ Years + Pre)

## ---------------------------------------------------------------------------------------------------------------------
r

## ---------------------------------------------------------------------------------------------------------------------
names(r)

## ---------------------------------------------------------------------------------------------------------------------
r$out_estimates

## ---------------------------------------------------------------------------------------------------------------------
r$coefficients

## ---------------------------------------------------------------------------------------------------------------------
cnt <- contr.sum(n=3)
cnt

## ----fig.width=4.5, fig.height=4--------------------------------------------------------------------------------------
d$Plan <- factor(d$Plan)
reg_brief(Salary ~ Plan, contrasts=list(Plan=cnt))

## ----fig.width=5------------------------------------------------------------------------------------------------------
reg_brief(Salary ~ 1, plot_errors=TRUE)

## ----fig.width=4, fig.height=4----------------------------------------------------------------------------------------
Logit(Gender ~ Salary)

