\name{rbcoverage}
\alias{rbcoverage}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Compute rule base coverage of data}
\description{
    This function computes rule base coverage, i.e. a an average of maximum membership degree at
    which each row of data fires the rules in rule base.
}
\usage{
rbcoverage(x, 
           rules,
           tnorm=c("minimum", "product", "lukasiewicz"),
           onlyAnte=TRUE)
}
\arguments{
    \item{x}{
        Data for the rules to be evaluated on. Could be either a numeric matrix or numeric vector.
        If matrix is given then the rules are evaluated on rows. Each value of the vector or column
        of the matrix represents a predicate - it's numeric value represents the truth values
        (values in the interval [0, 1]).
    }
    \item{rules}{
        Either an object of class "farules" or list of character vectors where each vector is a rule
        with consequent being the first element of the vector. Elements of the vectors (predicate
        names) must correspond to the \code{x}'s names (of columns if \code{x} is a matrix).
    }
    \item{tnorm}{
        A character string representing a triangular norm to be used (either \code{"minimum"},
        \code{"product"}, or \code{"lukasiewicz"}) or an arbitrary function that takes a vector 
        of truth values and returns a t-norm computed of them.
    }
    \item{onlyAnte}{
        TRUE if only antecedent-part of a rule should be evaluated. Antecedent-part of a rule are
        all predicates in rule vector starting from the 2nd position. (First element of a rule is
        the consequent - see above.)

        If FALSE, then the whole rule will be evaluated (antecedent part together with consequent).
    }
}
\details{
    Let \eqn{f_{ij}} be a truth value of \eqn{i}-th rule on \eqn{j}-th row of data \code{x}.
    Then \eqn{m_j = max(f_{.j})} is a maximum truth value that is reached for the \eqn{j}-th data
    row with the rule base. Then the rule base coverage is a mean of that truth values, i.e.
    \eqn{rbcoverage = mean(m_.)}.
}
\value{
    A numeric value of the rule base coverage of given data.
}
\references{
    M. Burda, M. Štěpnička, Reduction of Fuzzy Rule Bases Driven by the Coverage of Training Data,
    in: Proc. 16th World Congress of the International Fuzzy Systems
    Association and 9th Conference of the European Society for Fuzzy
    Logic and Technology (IFSA-EUSFLAT 2015), Advances in Intelligent
    Systems Research, Atlantic Press, Gijon, 2015.
}
\author{
    Michal Burda
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{fire}},
  \code{\link{reduce}}
}

\examples{
    x <- matrix(1:20 / 20, nrow=2)
    colnames(x) <- letters[1:10]

    rules <- list(c('a', 'c', 'e'),
                  c('b'),
                  c('d', 'a'),
                  c('c', 'a', 'b'))
    rbcoverage(x, rules, "product", TRUE)  # returns 1


    rules <- list(c('d', 'a'),
                  c('c', 'a', 'b'))
    rbcoverage(x, rules, "product", TRUE)  # returns 0.075)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ robust }
\keyword{ multivariate }
