% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exprs.R
\name{triangular}
\alias{triangular}
\alias{raisedcosine}
\title{Factories for functions that convert numeric data into membership degrees of fuzzy sets}
\usage{
triangular(lo, center, hi)

raisedcosine(lo, center, hi)
}
\arguments{
\item{lo}{A lower bound (can be -Inf).}

\item{center}{A peak value.}

\item{hi}{An upper bound (can be Inf).}
}
\value{
A function with single argument \code{x} that should be a numeric vector to be converted.
}
\description{
These functions create functions with a single argument \code{x} that compute membership degrees of \code{x} to a fuzzy set
of either triangular or raised-cosine shape that is defined by \code{lo}, \code{center}, and \code{hi}.
}
\details{
The arguments must satisfy \verb{lo <= center <= hi}. Functions compute membership degrees of triangular or
raised-cosine fuzzy sets. \code{x} values equal to \verb{center obtain membership degree equal to 1, }x\verb{values lower than}lo\verb{or greater than}hi\verb{obtain membership degree equal to 0. A transition of the triangular (resp. raised cosine) shape (with peak at}center\verb{is computed for}x\verb{values between}lo\code{and}hi`.

If \code{lo == -Inf} then any value that is lower or equal to center gets membership degree 1.  Similarly, if \code{hi == Inf}
then any value that is greater or equal to center gets membership degree 1. \code{NA} and \code{NaN} values remain unchanged.

\code{triangular()} produces fuzzy sets of a triangular shape (with peak at \code{center}), \code{raisedcosine()} produces
fuzzy sets defined as a raised cosine hill.
}
\examples{

tr <- triangular(1, 2, 3)
tr(1:30 / 3)

rc <- raisedcosine(1, 2, 3)
rc(1:30 / 3)

plot(triangular(-1, 0, 1), from=-2, to=3)
plot(triangular(-1, 0, 2), from=-2, to=3)
plot(triangular(-Inf, 0, 1), from=-2, to=3)
plot(triangular(-1, 0, Inf), from=-2, to=3)

plot(raisedcosine(-1, 0, 1), from=-2, to=3)
plot(raisedcosine(-1, 0, 2), from=-2, to=3)
plot(raisedcosine(-Inf, 0, 1), from=-2, to=3)
plot(raisedcosine(-1, 0, Inf), from=-2, to=3)

}
\seealso{
\code{\link[=fcut]{fcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{multivariate}
\keyword{robust}
