\name{lgcpSimSpatialCovariates}
\alias{lgcpSimSpatialCovariates}
\title{lgcpSimSpatialCovariates function}
\usage{
  lgcpSimSpatialCovariates(formula, owin,
    regionalcovariates = NULL, pixelcovariates = NULL,
    Zmat = NULL, beta, poisson.offset = NULL, cellwidth,
    model.parameters, spatial.covmodel = "exponential",
    covpars = c(), ext = 2, plot = FALSE,
    inclusion = "touching")
}
\arguments{
  \item{formula}{a formula of the form X ~ var1 + var2
  etc.}

  \item{owin}{the observation window on which to do the
  simulation}

  \item{regionalcovariates}{an optional object of class
  SpatialPolygonsDataFrame containing covariates}

  \item{pixelcovariates}{an optional object of class
  SpatialPixelsDataFrame containing covariates}

  \item{Zmat}{optional design matrix, if the
  polygon/polygon overlays have already been computed}

  \item{beta}{the parameters, beta for the model}

  \item{poisson.offset}{the poisson offet, created using a
  SpatialAtRisk.fromXYZ class of objects}

  \item{cellwidth}{the with of cells on which to do the
  simulation}

  \item{model.parameters}{the paramters of the model eg
  list(sigma=1,phi=0.2)}

  \item{spatial.covmodel}{the choice of spatial covariance
  model, can be anything from the RandomFields covariance
  function, CovariacenFct.}

  \item{covpars}{additional covariance parameters, for the
  chosen model, optional.}

  \item{ext}{the amount by which to extend the observation
  grid in each direction, default is 2}

  \item{plot}{whether to plot the resulting data}

  \item{inclusion}{criterion for cells being included into
  observation window. Either 'touching' or 'centroid'. The
  former, the default, includes all cells that touch the
  observation window, the latter includes all cells whose
  centroids are inside the observation window.}
}
\value{
  a ppp onject containing the simulated data
}
\description{
  A function to simulate a spatial LGCP.
}

