% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgcpStructures.R
\name{covEffects}
\alias{covEffects}
\title{covEffects function}
\usage{
covEffects(Y, beta, eta, Z, otherargs)
}
\arguments{
\item{Y}{the latent field}

\item{beta}{the main effects}

\item{eta}{the parameters of the latent field}

\item{Z}{the design matrix}

\item{otherargs}{other arguments to the function (see vignette "Bayesian_lgcp" for an explanation)}
}
\value{
the main effects
}
\description{
A function used in conjunction with the function "expectation" to compute the main covariate effects,\cr
    lambda(s) exp[Z(s)beta] \cr
in each computational grid cell. Currently
only implemented for spatial processes (lgcpPredictSpatialPlusPars and lgcpPredictAggregateSpatialPlusPars).
}
\examples{
\dontrun{ex <- expectation(lg,covEffects)[[1]] # lg is output from spatial LGCP MCMC}
}
\seealso{
\link{expectation},  \link{lgcpPredictSpatialPlusPars}, \link{lgcpPredictAggregateSpatialPlusPars}
}
