% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_logging.R
\name{basic_config}
\alias{basic_config}
\title{Basic Setup for the Logging System}
\usage{
basic_config(file = NULL, fmt = NULL,
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%OS3", threshold = NA,
  appenders = NULL)
}
\arguments{
\item{file}{\code{character} scalar: If not \code{NULL} a \link{AppenderFile} will be created
that logs to this file. If the filename ends in \code{.jsonl} an \link{AppenderJson}
will be created instead.}

\item{fmt}{\code{character} scalar: Format to use if \code{file} is supplied and not
a \code{.jsonl} file. If \code{NULL} it defaults to \code{"\%L [\%t] \%m"}
(see \link{format.LogEvent})}

\item{timestamp_fmt}{see \code{\link[=format.POSIXct]{format.POSIXct()}}}

\item{threshold}{\code{character} or \code{integer} scalar.
The minimum \link[=log_levels]{log level} that should be processed by the root
logger.}

\item{appenders}{a single \link{Appender} or a list thereof. Must be \code{NULL} if
if \code{file} is already specified.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Quick and easy way to configure the root logger for logging to a file
}
\examples{
\dontrun{
make the root logger log to a file
basic_config(file = tempfile())
}
}
