% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_logging.R
\name{simple_logging}
\alias{simple_logging}
\alias{log_exception}
\alias{threshold}
\alias{console_threshold}
\alias{add_appender}
\alias{remove_appender}
\alias{show_log}
\alias{show_dt}
\alias{show_data}
\title{Simple Logging}
\usage{
log_exception(code, logfun = lgr$fatal, caller = get_caller(-3))

threshold(level, target = lgr::lgr)

console_threshold(level, target = lgr::lgr$appenders$console)

add_appender(appender, name = NULL, target = lgr::lgr)

remove_appender(pos, target = lgr::lgr)

show_log(threshold = NA_integer_, n = 20L, target = lgr::lgr)

show_dt(target = lgr::lgr)

show_data(target = lgr::lgr)
}
\arguments{
\item{code}{Any \R code}

\item{logfun}{a \code{function} for processing the log request, usually
\code{lgr$info()}, \code{lgr$debug()}, etc... .}

\item{caller}{a \code{character} scalar. The name of the calling function}

\item{level}{\code{integer} or \code{character} scalar: the desired log level}

\item{target}{a \link{Logger} or \link{Appender} or the name of a Logger as \code{character}
scalar}

\item{appender}{an \code{Appender}}

\item{name}{\code{character} scalar. An optional name for the new Appender.}

\item{pos}{\code{integer} index or \code{character} names of the appenders to remove}

\item{threshold}{\code{character} or \code{integer} scalar. The minimum \link[=log_levels]{log level} that should be processed by the root logger.}

\item{n}{\code{integer} scalar. Show only the last \code{n} log entries that match
\code{threshold}}
}
\value{
\code{threshold()} and \code{console_threshold()} return the \link{log_level} of \code{target}
as \code{integer} (invisibly)

\code{add_appender()} and \code{remove_appender()} return \code{target}.

\code{show_log()} prints to the console and returns whatever the target
Appender's \code{$show()} method returns, usually a \code{character} vector,
\code{data.frame} or \code{data.table} (invisibly).

\code{show_data()} always returns a \code{data.frame} and \code{show_dt()} always returns
a \code{data.table}.
}
\description{
lgr provides convenience functions managing the root Logger. These are
designed chiefly for interactive use and are less verbose than their
R6 method counterparts.

\code{threshold()} sets or retrieves the threshold for an \link{Appender} or \link{Logger}
(the minimum level of log messages it processes). It's \code{target} defaults to
the root logger. (equivalent to \code{lgr::lgr$threshold} and
\code{lgr::lgr$set_threshold})

\code{console_threshold()} is a shortcut to set the threshold of the root
loggers \link{AppenderConsole}, which is usually the only Appender that manages
console output for a given \R session. (equivalent to
\code{lgr::lgr$appenders$console$threshold} and
\code{lgr::lgr$appenders$console$set_threshold})

\code{add_appender()} and \code{remove_appender()} add Appenders to Loggers and other
Appenders. (equivalent to \code{lgr::lgr$add_appender} and
\code{lgr::lgr$remove_appender})

\code{show_log()} displays the last \code{n} log entries of an Appender (or a Logger
with such an Appender attached) with a \code{$show()} method. Most, but not all
Appenders support this function (try \link{AppenderFile} or \link{AppenderBuffer}).

\code{show_data()} and \code{show_dt()} work similar to \code{show_log()}, except that
they return the log as \code{data.frame} or \code{data.table} respectively. Only
Appenders that log to formats that can easily be converted to \code{data.frames}
are supported (try \link{AppenderJson} or \link{AppenderBuffer}).

The easiest way to try out this features is by adding an AppenderBuffer
to the root logger with \code{\link[=basic_config]{basic_config(memory = TRUE)}}.
}
\examples{
add_appender(AppenderConsole$new(), "second_console_appender")
lgr$fatal("Multiple console appenders are a bad idea")
remove_appender("second_console_appender")
lgr$info("Good that we defined an appender name, so it's easy to remove")

# Reconfigure the root logger
basic_config(memory = TRUE)

# log some messages
lgr$info("a log message")
lgr$info("another message with data", data = 1:3)

show_log()
show_data()


}
