% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogEvent.R
\name{as.data.frame.LogEvent}
\alias{as.data.frame.LogEvent}
\alias{as.data.table.LogEvent}
\alias{as_tibble.LogEvent}
\title{Coerce LogEvents to Data Frames}
\usage{
\method{as.data.frame}{LogEvent}(
  x,
  row.names = NULL,
  optional = FALSE,
  stringsAsFactors = FALSE,
  ...,
  box_if = function(.) !(is.atomic(.) && identical(length(.), 1L)),
  cols_expand = NULL
)

as.data.table.LogEvent(
  x,
  ...,
  box_if = function(.) !(is.atomic(.) && identical(length(.), 1L)),
  cols_expand = "msg"
)

as_tibble.LogEvent(
  x,
  ...,
  box_if = function(.) !(is.atomic(.) && identical(length(.), 1L)),
  cols_expand = "msg"
)
}
\arguments{
\item{x}{any \R object.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{currently ignored and only included for compatibility.}

\item{stringsAsFactors}{\code{logical} scalar: should \code{character} vectors be
converted to factors? Defaults to \code{FALSE} (as opposed to
\code{\link[base:as.data.frame]{base::as.data.frame()}}) and is only included for compatibility.}

\item{...}{passed on to \code{data.frame()}}

\item{box_if}{a \code{function} that returns \code{TRUE} or \code{FALSE} to determine
which values are to be boxed (i.e. placed as single elements in a list
column). See example}

\item{cols_expand}{\code{character} vector. Columns to \emph{not} box (even if
\code{box_if()} returns \code{TRUE}). Vectors in these columns will result in multiple
rows in the result (rather than a single list-column row). This defaults to
\code{"msg"} for vectorized logging over the log message.}
}
\description{
Coerce LogEvents to \code{data.frames}, \code{\link[data.table:data.table]{data.tables}},
or \code{\link[tibble:tibble]{tibbles}}.
}
\examples{
lg <- get_logger("test")
lg$info("lorem ipsum")
as.data.frame(lg$last_event)

lg$info("LogEvents can store any custom log values", df = iris)
as.data.frame(lg$last_event)
head(as.data.frame(lg$last_event)$df[[1]])

# how boxing works

# by default non-scalars are boxed
lg$info("letters", letters = letters)
as.data.frame(lg$last_event)

# this behaviour can be modified by supplying a custom boxing function
as.data.frame(lg$last_event, box_if = function(.) FALSE)
as.data.frame(lg$last_event, cols_expand = "letters")

# The `msg` argument of a log event is always vectorized
lg$info(c("a vectorized", "log message"))
as.data.frame(lg$last_event)

lg$config(NULL)
}
\seealso{
\link[data.table:data.table]{data.table::data.table}, \link[tibble:tibble]{tibble::tibble}
}
