% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_size}
\alias{lib_size}
\title{Get the Size of a Data Library}
\usage{
lib_size(x)
}
\arguments{
\item{x}{The data library.}
}
\value{
The size of the data library in bytes as stored on the file system.
}
\description{
The \code{lib_size} function returns the number of bytes used
by the data library, as stored on disk.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add some data to library
lib_add(dat, mtcars)
lib_add(dat, iris)

# Check size of library
lib_size(dat)
# [1] 9757

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
