% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_index.r
\name{catalog_index}
\alias{catalog_index}
\title{Retrieve the tiles containing ROIs}
\usage{
catalog_index(obj, x, y, r, r2 = NULL, roinames = NULL)
}
\arguments{
\item{obj}{A Catalog object}

\item{x}{vector. A set of x plot coordinates}

\item{y}{vector. A set of y plot coordinates}

\item{r}{numeric or vector. A radius or a set of radii of the ROI. If only
r is provided (r2 = NULL) it will extract data falling onto a disc.}

\item{r2}{numeric or vector. A radius or a set of radii of plots. If r2
is provided, the selection turns into a rectangular ROI. If r= r2 it is a square.}

\item{roinames}{vector. A set of ROI names}
}
\description{
When the user has a set of (x, y) coordinates corresponding to a region of interest (ROI)
(a ground inventory, for example), they can automatically find the tiles containing the lidar data associated
with the ROIs from a \link[lidR:catalog]{Catalog}. The algorithm will do this even for ROIs falling on the edges of one or
more tiles.\cr
It only works for tiles that are arranged in gridlines. This function is used by \link[lidR:catalog_queries]{catalog_queries}.
Users do not really need it.
}
\seealso{
\link[lidR:catalog]{Catalog}
\link[lidR:catalog_queries]{catalog_queries}
}

