% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_catalog.r
\name{grid_catalog}
\alias{grid_catalog}
\title{Apply a grid function over a catalog}
\usage{
grid_catalog(catalog, grid_func, res, select = "*", filter = "",
  start = c(0, 0), ...)
}
\arguments{
\item{catalog}{A \link[lidR:LAScatalog-class]{LAScatalog}}

\item{grid_func}{A function that returns a \code{lasmetrics} object. This function must follow a
specific template (see details and examples)}

\item{res}{numeric. Resolution of the grid}

\item{select}{character. The 'select' parameter from \link{readLAS}.}

\item{filter}{character. The 'filter' parameter from \link{readLAS}.}

\item{start}{numeric. The 'start' parameter from \link{grid_metrics}}

\item{...}{Any other parameter required by \code{grid_func}}
}
\value{
Returns a \code{data.table} containing the metrics for each cell. The table
has the class "lasmetrics" enabling easy plotting.
}
\description{
This function applies over an entire catalog any user-defined function that returns a \code{lasmetrics} object. Used internaly by \link{grid_metrics}, \link{grid_terrain}, \link{grid_canopy} and other
\code{grid_*} functions when the input is a \code{LAScatalog}, it ensures continuous rasterization of
the dataset and performs pre- and post-processes. This function can be seen as a straightforward
'grid-specific' version of \link{catalog_apply}, which is even more generic.
}
\details{
The user-defined function \code{grid_func} must respect a template. Like in \link{grid_metrics},
\link{grid_terrain} or \link{grid_canopy}, the user-defined function must have a parameter called
\code{x} that will receive a \code{LAS} object and a parameter \code{res} that will receive the
resolution of the grid. The parameter \code{start} is optional.
}
\examples{
# This example computes the mean elevation of points above 5 m over an entire
# catalog, after removing all points in lakes into a shapefile.

LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
shapefile_dir <- system.file("extdata", package = "lidR")

ctg = catalog(LASfile)
tiling_size(ctg) <- 160

lakes = rgdal::readOGR(shapefile_dir, "lake_polygons_UTM17")

my_grid_metrics = function(x, res, spdf)
{
  lasclassify(x, spdf, "inpoly")
  x = lasfilter(x, !inpoly)
  grid_metrics(x, mean(Z), res)
}

mean = grid_catalog(ctg, my_grid_metrics, 20,
                    select = "xyz", filter = "-drop_z_below 5",
                    spdf = lakes)

}
