% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-lascatalog.r
\docType{class}
\name{LAScatalog-class}
\alias{LAScatalog-class}
\title{An S4 class to represent a set of .las or .laz files}
\description{
A \code{LAScatalog} object is a representation of a set of las/laz files, since a computer cannot load
all the data at once. A \code{LAScatalog} is a simple way to manage the entire dataset by reading only
the file headers. A \code{LAScatalog} enables the user to process a large area or to
selectively clip data from a large area without loading the large area itself. A \code{LAScatalog}
can be built with the function \link{catalog}. Also a \code{LAScatalog} contains extra information
that enables users to control how the catalog is processed (see details).
}
\details{
A \code{LAScatalog} contains a slot @data that contains the useful information about the point cloud
that is used internally, as well as several other slots that contain \bold{processing options}. Each
\code{lidR} function that supports a \code{LAScatalog} as input will respect this processing option
when it is relevant. When it is not relevant these options are not considered. Examples of some non-
relevant situations:
\itemize{
\item \code{@vrt} options is not relevant in functions that do not rasterize the point cloud.
\item \code{@tiling_size} is always respected but can be slighly modified to align the clusters with 
the grid in \code{grid_*} functions.
\item \code{@buffer} is not relevant in \link{grid_metrics} because \code{lidR} aligns the
clusters with the resolution to get a continuous output. However it is relevant in \link{grid_terrain}
to avoid edge artifacts, for example.
\item \code{@cores} may not be respected if it is known internally that a single core is better
than four (no current case currently exists)
}
Internally, processing a catalog is almost always the same and relies on few steps:
\itemize{
\item Create a set of clusters. A cluster is the representation of a region of interest that can be 
buffered or not.
\item Loop over each cluster (in parallel or not)
\item For each cluster, load the points inside the region of interest in R, run some R functions,
return the expected output.
\item Merge the outputs of the different clusters once they are all processed.
}
So basically, a \code{LAScatalog} is a built in batch process with the specificity that \code{lidR}
does not loop through files but loops seamlessly through clusters that do not not necessarily match
with the files. This is why point cloud indexation with lax files may significantly speed-up the
processing.\cr\cr
It is important to note that buffered datasets (i.e. files that overlap each other) are not natively
supported by \code{lidR}. When encountering such datasets the user should always filter the
overlap if possible. This is possible if the overlapping points are flagged, for example in the
'withheld' field. Otherwise \code{lidR} will not be able to process the dataset correctly.
}
\section{Slots}{

\describe{
\item{\code{data}}{data.table. A table representing the header of each file.}

\item{\code{crs}}{A \link[sp:CRS]{CRS} object.}

\item{\code{cores}}{integer. Numer of cores used to make parallel computations in compatible functions that
support a \code{LAScatalog} as input. Default is 1.}

\item{\code{buffer}}{numeric. When applying a function to an entire catalog by sequentially processing
sub-areas (clusters), some algorithms (such as \link{grid_terrain}) require a buffer around the area
to avoid edge effects. Default is 15 units.}

\item{\code{progress}}{logical. Display an estimation of progress while processing. Default is TRUE.}

\item{\code{by_file}}{logical. This option overwrites the option \code{tiling_size}. Instead of processing
the catalog by arbitrary split areas, it forces processing by file. Buffering around each file is
still available. Default is FALSE.}

\item{\code{tiling_size}}{numeric. To process an entire catalog, the algorithm splits the dataset into
several square sub-areas (called clusters) to process them sequentially. This is the size of each 
square cluster. Default is 1000 unit^2.}

\item{\code{vrt}}{character. Path to a folder. In \code{grid_*} functions such as \link{grid_metrics},
\link{grid_terrain} and others, the functions can write \code{RasterLayers} in this folder and
return a lightweight virtual raster mosaic (VRT). In other functions where it is not relevant,
it is not used.}

\item{\code{stop_early}}{logical. If \code{TRUE} the catalog processing stops if an error occurs during the
computation. If \code{FALSE}, the catalog will be processed until the end anyway and clusters with
errors will be skipped.}

\item{\code{opt_changed}}{Internal use only for compatibility with older deprecated code.}
}}

\seealso{
\link[lidR:catalog]{catalog}
}
