% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_tincanopy.r
\name{grid_tincanopy}
\alias{grid_tincanopy}
\title{Canopy height model based on a triangulation.}
\usage{
grid_tincanopy(x, res = 0.5, thresholds = c(0, 2, 5, 10, 15),
  max_edge = c(0, 1), subcircle = 0, filter = "-keep_first")
}
\arguments{
\item{x}{A LAS object}

\item{res}{numeric. Resolution of the canopy height model.}

\item{thresholds}{numeric. Set of height thresholds. If \code{thresholds = 0} the algorithm
is a strict rasterization of the triangulation of the first returns. However, if an array is
passed to the function it becomes the Khosravipour et al. pit-free algorithm.}

\item{max_edge}{numeric. Maximum edge-length of a triangle in the Delaunay triangulation.
If a triangle has an edge greater than this value it will be removed. It is used to drive
the pit-free algorithm (see reference) and to trim dummy interpolation on non-convex areas.
The first number is the value for the classical triangulation (threshold = 0), the second number
is the value for the pit-free algorithm (for thresholds > 0). If \code{max_edge = 0} no trimming
is done.}

\item{subcircle}{numeric. Radius of the circles. To obtain fewer pits the algorithm
can replace each return with a circle consisting of 8 points before computing the triangulation
(see also \link{grid_canopy}).}

\item{filter}{character. Streaming filter while reading the files (see \link{readLAS}).
If the input is a \code{LAScatalog} the function \link{readLAS} is called internally. The
user cannot manipulate the lidar data directly but can use streaming filters instead.}
}
\value{
Returns a \code{data.table} of class \code{lasmetrics}, which enables easier
plotting and RasterLayer casting.
}
\description{
Canopy height model based on a triangulation of first returns. Depending on the inputs
this function computes a simple Delaunay triangulation of the first returns with a linear
interpolation within each triangle. This function also enables the use of the pit-free algorithm
developed by Khosravipour et al. (2014), which is based on the computation of a set of classical
triangulations at different heights (see reference).
}
\section{Use with a \code{LAScatalog}}{

When the parameter \code{x} is a \link[lidR:LAScatalog-class]{LAScatalog} the function processes
the entire dataset in a continuous way using a multicore process. The user can modify the processing
options using the \link[lidR:catalog]{available options}.\cr\cr
\code{lidR} supports .lax files. Computation speed will be \emph{significantly} improved with a
spatial index.
}

\examples{
LASfile = system.file("extdata", "MixedConifer.laz", package="lidR")
las = readLAS(LASfile, select = "xyzr", filter = "-drop_z_below 0")

# Basic triangulation and rasterization
chm1 = grid_tincanopy(las, thresholds = 0, max_edge = 0)

# Khosravipour et al. pitfree algorithm
chm2 = grid_tincanopy(las, thresholds = c(0,2,5,10,15), max_edge = c(0, 1.5))

plot(chm1)
plot(chm2)
}
\references{
Khosravipour, A., Skidmore, A. K., Isenburg, M., Wang, T., & Hussin, Y. A. (2014).
Generating pit-free canopy height models from airborne lidar. Photogrammetric Engineering &
Remote Sensing, 80(9), 863-872.
}
