% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lasmetrics.r
\name{plot.lasmetrics}
\alias{plot.lasmetrics}
\title{Plot an object of class lasmetrics in 2D}
\usage{
\method{plot}{lasmetrics}(x, z = NULL, colorPalette = height.colors(50),
  trim = Inf, ...)
}
\arguments{
\item{x}{A data.frame or data.table of class \code{lasmetrics}.}

\item{z}{character. The field to plot. If NULL, autodetect.}

\item{colorPalette}{characters. a list of colors such as those generated by heat.colors,
topo.colors, terrain.colors or similar functions. Default is \code{height.colors(50)}
provided by the package \code{lidR}}

\item{trim}{numeric. Enables trimming of values when outliers break the color palette range.
Default is +Inf (no trimming), meaning that the whole range of values is used for the color
palette. 10 means that the values greater than 10 are all assigned to the highest color.}

\item{\dots}{Supplementary parameters for \link[raster:plot]{plot}}
}
\description{
This functions implements a plot method for a \code{lasmetrics} data.frame
}
\details{
The \dots param provides additional arguments to \link[raster:plot]{plot}.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)

# Canopy surface model with 4 m^2 cells
plot(grid_canopy(las))

# Mean height with 400 m^2 cells
plot(grid_metrics(las, mean(Z)))

# With multiple metrics
metrics = grid_metrics(las, .stdmetrics_z)

plot(metrics)
plot(metrics, "zmean")
plot(metrics, "zmax")
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[lidR:grid_canopy]{grid_canopy}
\link[lidR:height.colors]{height.colors}
\link[lidR:forest.colors]{forest.colors}
\link[grDevices:heat.colors]{heat.colors}
\link[grDevices:colorRamp]{colorRampPalette}
}
