% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastrees.r
\name{lastrees}
\alias{lastrees}
\title{Individual tree segmentation}
\usage{
lastrees(las, algorithm, attribute = "treeID")
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS}.}

\item{algorithm}{function. An algorithm of individual tree segmentation. \code{lidR} has:
\link{dalponte2016}, \link{watershed}, \link{mcwatershed}, \link{li2012} and \link{silva2016}.
More experimental algorithms may be found in the package \href{https://github.com/Jean-Romain/lidRplugins}{lidRplugins}}

\item{attribute}{character. The returned LAS object as a new extra byte attribute (in a new column).
This parameter controls the name of the new attribute. Default is \code{"treeID"}.}
}
\value{
An object of the class \code{LAS}
}
\description{
Individual tree segmentation with several possible algorithms. The returned point cloud has a new
extra byte attribute named after the parameter \code{attribute} independently of the algorithm used.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")
col <- pastel.colors(200)

# Using Li et al. (2012)
las <- lastrees(las, li2012(R = 3, speed_up = 5))
plot(las, color = "treeID", colorPalette = col)
}
