% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_poi.R
\name{filter_poi}
\alias{filter_poi}
\title{Filter points of interest with matching conditions}
\usage{
filter_poi(las, ...)
}
\arguments{
\item{las}{An object of class \code{\link[=LAS-class]{LAS}}}

\item{\dots}{Logical predicates. Multiple conditions are combined with '&' or ','}
}
\value{
An object of class \code{\link[=LAS-class]{LAS}}
}
\description{
Filter points of interest (POI) from  a LAS object where conditions are true.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Select the first returns classified as ground
firstground = filter_poi(lidar, Classification == 2L & ReturnNumber == 1L)

# Multiple arguments are equivalent to &
firstground = filter_poi(lidar, Classification == 2L, ReturnNumber == 1L)

# Multiple criteria
first_or_ground = filter_poi(lidar, Classification == 2L | ReturnNumber == 1L)
}
\seealso{
Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_surfacepoints}()},
\code{\link{filters}}
}
\concept{filters}
