% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cloudMetrics}
\alias{cloudMetrics}
\title{Computes metrics on list of point clouds}
\usage{
cloudMetrics(
  llasn,
  func = ~lidR::stdmetrics(X, Y, Z, Intensity, ReturnNumber, Classification, dz = 1)
)
}
\arguments{
\item{llasn}{list of \code{\link[lidR]{LAS}} objects}

\item{func}{function. function applied on each element to compute metrics, default function is \code{\link[lidR]{stdmetrics}} from package \code{lidR}}
}
\value{
A data frame with metrics in columns corresponding to LAS objects of the list (lines)
}
\description{
Computes metrics for a list of \code{\link[lidR]{LAS}} objects (should be normalized point clouds). Calls the function \code{\link[lidR]{cloud_metrics}} on each element and then arranges the results in a data.frame.
}
\examples{
data(laschablais3)

# extract four point clouds from LAS object
llas <- list()
llas[["A"]] <- lidR::clip_circle(laschablais3, 974350, 6581680, 10)
llas[["B"]] <- lidR::clip_circle(laschablais3, 974390, 6581680, 10)
llas[["C"]] <- lidR::clip_circle(laschablais3, 974350, 6581640, 10)
# normalize point clouds
llas <- lapply(llas, function(x) {lidR::normalize_height(x, lidR::tin())})

# compute metrics
cloudMetrics(llas)

# compute metrics with user-defined function
# mean and standard deviation of first return points above 10 m
user.func <- function(z, rn, hmin = 10)
{
# first return above hmin subset
dummy <- which(z >= hmin & rn == 1)
return(list(
 mean.z = mean(z[dummy]),
 sd.z = stats::sd(z[z>hmin])
 ))
 }
 cloudMetrics(llas, func=~user.func(Z, ReturnNumber, 10))
}
\seealso{
\code{\link[lidR]{cloud_metrics}}, \code{\link[lidR]{stdmetrics}}, \code{\link{ABAmodelMetrics}}
}
