% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{segAdjust}
\alias{segAdjust}
\title{Modification of segments based on values}
\usage{
segAdjust(dem.w, dem.wh, dem.nl, prop = 0.3, min.value = 2, min.maxvalue = 5)
}
\arguments{
\item{dem.w}{cimg or rasterLayer object. image with segments id, without 0 values}

\item{dem.wh}{cimg or rasterLayer object. image with max value inside segment}

\item{dem.nl}{cimg or rasterLayer object. image with initial values}

\item{prop}{numeric. proportional threshold for removal of pixels which initial values are lower than the max height of the segment (\code{dem.nl < prop x dem.wh})}

\item{min.value}{numeric. threshold for removel of pixels which initial values are lower (\code{dem.nl < min.value})}

\item{min.maxvalue}{numeric. threshold for complete removal of segments which maximum value height is smaller to the threshold (\code{dem.wh < min.maxvalue})}
}
\value{
A cimg or rasterLayer object: image with modified segments.
}
\description{
in a segmented image, removes from segments the pixels which values in a reference image is below a certain percentage of the highest value inside the segment. Removed pixels are attributed 0 value.
}
\examples{
data(chmchablais3)

# median filter
chmchablais3 <- demFiltering(chmchablais3, nlFilter="Median", nlSize=3,
                             sigmap=0)$non.linear.image

# maxima detection and selection
maxi <- maximaDetection(chmchablais3)
selected.maxi <- maximaSelection(maxi, chmchablais3, dm=1, dprop=0.1)

# segmentation
seg.selected.maxi <- segmentation(selected.maxi, chmchablais3)

# max value in segments
max.in.segment <- rasterZonalStats(seg.selected.maxi, chmchablais3)

# segmentation modification
seg.modif1 <- segAdjust(seg.selected.maxi, max.in.segment,
 chmchablais3, prop=0.5)
seg.modif2 <- segAdjust(seg.selected.maxi, max.in.segment,
 chmchablais3, prop=0, min.value=5, min.maxvalue=10)

# plot initial segmented image
seg.selected.maxi[seg.selected.maxi==0] <- NA
raster::plot(seg.selected.maxi \%\% 8, main="Initial segments", col=rainbow(8))
seg.modif1[seg.modif1==0] <- NA
raster::plot(seg.modif1 \%\% 8, main="Modified segments 1", col=rainbow(8))
seg.modif2[seg.modif2==0] <- NA
raster::plot(seg.modif2 \%\% 8, main="Modified segments 2", col=rainbow(8))
}
\seealso{
\code{\link{maximaDetection}}, \code{\link{maximaSelection}}
}
