% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{boxcox_itr}
\alias{boxcox_itr}
\title{Inverse Box-Cox transformation}
\usage{
boxcox_itr(x, lambda)
}
\arguments{
\item{x}{vector or RasterLayer. values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}
}
\value{
a vector or RasterLayer of transformed values
}
\description{
Inverse Box-Cox transformation
}
\examples{
x <- 1:10
boxcox_itr(x, 0)
boxcox_itr(x, 0.5)
boxcox_itr(x, 2)
boxcox_itr(boxcox_tr(x, 2), 2)

# plot functions
curve(boxcox_itr(x, 0), 0, 3,
  col = "blue", main = "inverse Box Cox transf.",
  xlab = "x", ylab = "inverse Boxcox(x, lambda)"
)
curve(boxcox_itr(x, 1.5), 0, 3, col = "red", add = TRUE)
curve(boxcox_itr(x, 0.5), 0, 3, col = "black", add = TRUE)
curve(boxcox_itr(x, 1), 0, 3, col = "pink", add = TRUE)
legend("topleft",
  legend = c("lambda", 0, 0.5, 1, 1.5),
  col = c(NA, "blue", "black", "pink", "red"), lty = 1
)
}
\seealso{
\code{\link{boxcox_tr}} Box-Cox transformation,
\code{\link{boxcox_itr_bias_cor}} inverse Box-Cox transformation with bias
correction.
}
