% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{clean_raster}
\alias{clean_raster}
\title{Applies thresholds and mask to a raster object}
\usage{
clean_raster(r, minmax = c(-Inf, +Inf), mask = NULL)
}
\arguments{
\item{r}{raster object. RasterLayer and SpatRaster are supported.}

\item{minmax}{vector of two numeric values. minimum and maximum thresholds to
apply to `r` values}

\item{mask}{raster object. mask to be applied (multiplication with input raster
`r`)}
}
\value{
a raster object
}
\description{
Applies a lower and upper thresholds to the values of the input raster. If the
 mask input is provided, first all NA values in the raster are set to 0, then
  the raster in multiplied by the mask. Cells to be masked should therefore
  have a NA value in the mask raster object.
}
\examples{
# load data
data(quatre_montagnes)
# build model
model_aba <- aba_build_model(quatre_montagnes$G_m2_ha, quatre_montagnes[, 9:76],
  transform = "boxcox"
)
# build example raster to apply model
quatre_montagnes$X <- rep(1:8, 12)
quatre_montagnes$Y <- rep(1:12, each = 8)
metrics_map <- terra::rast(quatre_montagnes[, c(2, 3, 9:76)], type = "xyz")
predict_map <- aba_predict(model_aba, metrics_map)
# create raster mask
mask <- predict_map
# set values to 1 or NA
terra::values(mask) <- rep(c(1, 1, NA), each = 32)
# apply thresholds and mask
predict_map_clean <- clean_raster(predict_map, c(40, 70), mask)

# plot maps
terra::plot(predict_map, main = "Predictions")
terra::plot(mask, main = "Mask", legend = FALSE)
terra::plot(predict_map_clean, main = "Cleaned predictions")
}
