% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{seg_adjust}
\alias{seg_adjust}
\title{Modification of segments based on values}
\usage{
seg_adjust(dem_w, dem_wh, dem_nl, prop = 0.3, min.value = 2, min.maxvalue = 5)
}
\arguments{
\item{dem_w}{cimg or SpatRaster object. image with segments id, without 0 
values}

\item{dem_wh}{cimg or SpatRaster object. image with max value inside segment}

\item{dem_nl}{cimg or SpatRaster object. image with initial values}

\item{prop}{numeric. proportional threshold for removal of pixels which initial 
values are lower than the max height of the segment (\code{dem_nl < prop x dem_wh})}

\item{min.value}{numeric. threshold for removel of pixels which initial values 
are lower (\code{dem_nl < min.value})}

\item{min.maxvalue}{numeric. threshold for complete removal of segments which 
maximum value height is smaller to the threshold (\code{dem_wh < min.maxvalue})}
}
\value{
A cimg or SpatRaster object: image with modified segments.
}
\description{
in a segmented image, removes from segments the pixels which values in a 
reference image is below a certain percentage of the highest value inside the 
segment. Removed pixels are attributed 0 value.
}
\examples{
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)

# median filter
chm_chablais3 <- dem_filtering(chm_chablais3,
  nl_filter = "Median", nl_size = 3,
  sigma = 0
)$non_linear_image

# maxima detection and selection
maxi <- maxima_detection(chm_chablais3)
selected_maxi <- maxima_selection(maxi, chm_chablais3, dm = 1, dprop = 0.1)

# segmentation
seg_selected_maxi <- segmentation(selected_maxi, chm_chablais3)

# max value in segments
max_in_segment <- raster_zonal_stats(seg_selected_maxi , chm_chablais3)

# segmentation modification
seg_modif1 <- seg_adjust(seg_selected_maxi , max_in_segment,
  chm_chablais3,
  prop = 0.5
)
seg_modif2 <- seg_adjust(seg_selected_maxi , max_in_segment,
  chm_chablais3,
  prop = 0, min.value = 5, min.maxvalue = 10
)

# plot initial segmented image
# seg_selected_maxi[seg_selected_maxi == 0] <- NA
terra::plot(seg_selected_maxi \%\% 8, main = "Initial segments", col = rainbow(8))
# seg_modif1[seg_modif1 == 0] <- NA
terra::plot(seg_modif1 \%\% 8, main = "Modified segments 1", col = rainbow(8))
seg_modif2[seg_modif2 == 0] <- NA
terra::plot(seg_modif2 \%\% 8, main = "Modified segments 2", col = rainbow(8))
}
\seealso{
\code{\link{maxima_detection}}, \code{\link{maxima_selection}}
}
