\name{locus.likes} 
\alias{locus.likes} 
\title{likeLTD::locus.likes} 
\usage{locus.likes(hypothesis,results,\dots)}
\arguments{
  \item{hypothesis}{The hypothesis generated by either \code{prosecution.hypothesis} 
  or \code{defence.hypothesis}.}
  \item{results}{Either prosecution or defence results from \code{evaluate} 
e.g. \code{results$Pros} or \code{results$Def}.}
  \item{\dots}{Any extra parameter that was passed to \code{evaluate} or 
\code{optimisation.params}. }
}
\value{Vector.} 
\description{Vector with individual locus likelihoods.}
\details{
  Convert the overall likelihood returned by DEoptim into locus specific likelihoods.
}
\seealso{evaluate}
\examples{
\dontrun{
# datapath to example files
datapath = file.path(system.file("extdata", package="likeLTD"),"hammer")

# File paths and case name for allele report
admin = pack.admin.input(
            cspFile = file.path(datapath, 'hammer-CSP.csv'),
            refFile = file.path(datapath, 'hammer-reference.csv'),
            caseName = "hammer",
	    kit= "SGMplus"
             )

# Enter arguments
args = list(
        nUnknowns = 1,
        doDropin = FALSE,
        ethnic = "EA1",
        adj = 1,
        fst = 0.02,
        relatedness = c(0,0)
        )

# Create hypotheses
hypP = do.call(prosecution.hypothesis, append(admin,args))
hypD = do.call(defence.hypothesis, append(admin,args))

# Get parameters for optimisation
paramsP = optimisation.params(hypP)
paramsD = optimisation.params(hypD)

# Run optimisation
# n.steps set for demonstration purposes
results = evaluate(paramsP, paramsD, n.steps=1)

# get locus likelihoods under prosecution
locus.likes(hypP,results$Pros)

# get locus LRs
locus.likes(hypP,results$Pros)/locus.likes.peaks(hypD,results$Def)
}
}
