% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_2way_Factorial_ANOVA.R
\name{L_2way_Factorial_ANOVA}
\alias{L_2way_Factorial_ANOVA}
\title{Likelihood Supports for Two-way Independent Samples Factorial ANOVA}
\usage{
L_2way_Factorial_ANOVA(data, factor1, factor2, contrast1=NULL, contrast2=NULL, verb=TRUE)
}
\arguments{
\item{data}{a (non-empty) numeric vector of data values.}

\item{factor1}{a vector the same length as data, coding the first factor.}

\item{factor2}{a vector the same length as data, coding the second factor.}

\item{contrast1}{first contrast, with values for factor1 changing first, default = NULL.}

\item{contrast2}{second contrast, default = NULL.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.12c - corrected support for full model versus null.

$S.12 - uncorrected support for full model versus null.

$S_FMc - corrected support for full model versus main effects model.

$S.FM - uncorrected support for full versus main effects.

$S.c1.Mc - corrected support for first contrast versus main effects model.

$S.c1.M - uncorrected support for first contrast versus main effects.

$S.c1.c2 - support for first versus second contrast.

$Means - 2 way table of means.

$df - degrees of freedom for the ANOVA.

$F.f1 - F value for first factor main effect.

$Pval.f1 - P value for first factor main effect.

$eta.sq.1 - partial eta-squared for first factor main effect.

$F.f2 - F value for second factor main effect.

$Pval.f2 - P value for second factor main effect.

$eta.sq.2 - partial eta-squared for second factor main effect.

$F.int - F value for interaction.

$Pval.int - P value for interaction.

$eta.sq.12 - partial eta-squared for the interaction.

$F.val.c1 - F value for first contrast.

$P.val.c1 - P value for first contrast.
}
\description{
This function calculates supports for independent samples ANOVA. One support is
for the full model versus null (no factors), and the second is for full model
versus main effects. Two contrasts can be specified which can be used
to explore interactions. Each should be given
as a vector arranged as means for factor1 changing first (see example). If only the first
contrast is specified then this is compared to the main effects model. If a second
contrast is specified then the first contrast is compared to it.
Corrected support is given where appropriate, using
Akaike's correction (Hurvich & Tsai (1989)). No correction is necessary for the
two contrasts support since they both involve 1 parameter. Unequal group sizes are
accommodated, using type III sums of squares. F, p and partial eta-squared values
are given for the two factors and their interaction.
}
\examples{
# blood clotting times example, p 91
time <- c(6.4,	4.6,	6.4,	5.6,	5.9, 6.1,	6.3,	4.5,
4.8,	6.6, 7,	9.3,	7.9,	9.4,	8.2, 4.4,	4.2,	5,
6.9,	4.5, 4,	4.3,	6.9,	5.5,	5.8,
4.4,	4.2,	5.1,	6.9,	4.5)
Treatment = gl(3,5,30, labels=c("T1","T2","T3"))
Health = gl(2,15,30, labels=c("Hemophiliac","Normal"))

L_2way_Factorial_ANOVA(time, Treatment, Health)

contrast1 <- c(-1, -1, 5,
               -1, -1, -1) # interaction Hemo T3 higher than others
L_2way_Factorial_ANOVA(time, Treatment, Health, contrast1)

contrast2 <- c(-1, -1, -1,
               1, 1, 1) # main effect of health status (Hemo higher than Normal)

m=L_2way_Factorial_ANOVA(time, Treatment, Health, contrast1, contrast2)
m     #show outputs

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Hurvich CM, Tsai C-L. Regression and time series model selection in small
samples. Biometrika. 1989; 76(2):297.

Dixon P. The effective number of parameters in post hoc models. Behavior
Research Methods. 2013; 45(3):604.

Dixon P. The p-value fallacy and how to avoid it. Canadian Journal of
Experimental Psychology/Revue canadienne de psychologie expérimentale. 2003;
57(3):189.

Glover S, Dixon P. Likelihood ratios: a simple and flexible statistic for empirical
psychologists. Psychonomic Bulletin and Review. 2004; 11(5):791.
}
\keyword{ANOVA;}
\keyword{Likelihood;}
\keyword{contrasts}
\keyword{factorial}
\keyword{independent}
\keyword{samples}
\keyword{support;}
