% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_plot.R
\name{plot.lyl_aggregated}
\alias{plot.lyl_aggregated}
\title{Plot Life Years Lost at one specific age for two different populations obtained from
aggregated data}
\usage{
\method{plot}{lyl_aggregated}(x, colors = NA,
  labels = c("Population of interest", "Reference population"), ...)
}
\arguments{
\item{x}{An object of class \code{lyl_aggregated} (obtained with function \code{lyl_aggregated}).}

\item{colors}{Vector with one color for each cause of death. Default is NA, and
default colors are used.}

\item{labels}{Vector with labels for the two populations (default are "Population of
interest" for \code{data}, and "Reference population" for \code{data0}; which are provided
to function \code{lyl_aggregated}.)}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
A plot with survival function and stacked cause-specific cumulative incidences for two
populations side by side.
}
\description{
\code{plot} for objects of class \code{lyl_aggregated} creates a figure of Life Years Lost
at one specific age for two different populations.
}
\examples{
# Load simulated data as example
data(aggreg_data)
data(pop_ref)

# Estimate remaining life expectancy and Life Years
# Lost after age 70 years and before age 90 years
lyl_summary_data70 <- lyl_aggregated(data = aggreg_data, age = age, rates = rate,
                                     data0 = pop_ref, age0 = age, surv0 = survival,
                                     age_specific = 70, tau = 90)

# Plot the data
plot(lyl_summary_data70)

}
\seealso{
\itemize{
    \item{\code{\link{lyl_aggregated}} for estimation of Life Years Lost at one specific age.}
}

% @references \itemize{
    % \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition. \emph{In preparation}.}
% }
}
