% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_recodeTable_to_equations.R
\name{ls_recodeTable_to_equations}
\alias{ls_recodeTable_to_equations}
\title{Recode a set of LS variables codes and values into LSEM equations}
\usage{
ls_recodeTable_to_equations(
  data,
  varCodeCol = limonaid::opts$get("recTab2Eq_varCodeCol"),
  valueCol = limonaid::opts$get("recTab2Eq_valueCol"),
  recodeToCol = limonaid::opts$get("recTab2Eq_recodeToCol"),
  operatorCol = limonaid::opts$get("recTab2Eq_operatorCol"),
  elseExpr = limonaid::opts$get("eq_elseExpr"),
  naok = TRUE
)
}
\arguments{
\item{data}{The dataframe.}

\item{varCodeCol}{The name or index of the column with the variable code.}

\item{valueCol}{The name or index of the column with the values to compare
the value of the variable code to.}

\item{recodeToCol}{The name or index of the column with the value to return
in the case of a match.}

\item{operatorCol}{The name or index of the column with the operator used
to build each logical expression.}

\item{elseExpr}{The value to return if there are no matches.}

\item{naok}{Whether to append "\code{.NAOK}" to variable codes by default.}
}
\value{
A character value.
}
\description{
This function takes a dataframe with LimeSurvey (LS) variable codes
and values, and builds a nested set of LimeSurvey Equation Manager (LSEM)
if/then/else equations where the variable code in each row (in the
\code{varCodeCol}) is compared to the corresponding value (i.e. the value in
the same row in the \code{valueCol} column) using the operator specified in that
row in the \code{operatorCol} column (or the \code{==} operator, if no operator is
specified). In the case of a match, the value in the corresponding
\code{recodeToCol} column is returned. If there is no match, the comparison
on the next row is evaluated, all the way down. If nothing matches, the
\code{elseExpr} is returned.
}
\examples{
### Provide later
}
