% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_metrics.R
\name{event_coverage}
\alias{event_coverage}
\title{Event Coverage}
\usage{
event_coverage(e, closed = TRUE)
}
\arguments{
\item{e}{An event table.}

\item{closed}{Logical value indicating whether events should be interpreted as closed intervals. If \code{TRUE}, coverage is continuous at breaks between two adjacent events.}
}
\description{
Returns the intervals over which the number of events is always one or greater.
}
\details{
If \code{closed = TRUE}, breaks between adjacent events are dropped. If \code{closed = FALSE}, breaks between adjacent events are retained, including point events on line event endpoints. Duplicate points are dropped in both cases.
}
\examples{
e <- events(c(1, 2, 4, 8), c(3, 4, 5, 10))
event_coverage(e, closed = TRUE)  # retains breaks
event_coverage(e, closed = FALSE) # drops breaks
e <- events(c(0, 2, 2, 2, 8, 10), c(0, 2, 2, 6, 10, 10))
event_coverage(e, closed = TRUE)  # retains isolated points
event_coverage(e, closed = FALSE) # retains isolated points and points adjacent to lines
}
\seealso{
\code{\link{event_gaps}} for gaps (the inverse of coverage), \code{\link{event_range}} for range (coverage with gaps ignored).
}
