% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select.linelist}
\alias{select.linelist}
\title{Subset columns of a linelist object}
\usage{
\method{select}{linelist}(.data, ..., tags = NULL)
}
\arguments{
\item{.data}{a \code{linelist} object}

\item{...}{the variables to select, using \code{dplyr} compatible syntax}

\item{tags}{a \code{character} indicating tagged variables to select using tag
names (see \code{\link[=tags_names]{tags_names()}}) for default values; values can be named, in
which case the output columns will be renamed accordingly (e.g. \code{onset = "date_onset"} will output a column named 'onset').}
}
\value{
The function returns a \code{linelist} with selected columns.
}
\description{
This function works similarly to \code{\link[dplyr:select]{dplyr::select()}} but can in addition refer
to tagged variables through the \code{tags} argument. When variables are selected
using both procedures, tagged variables are output as the last columns.
}
\examples{
if (require(outbreaks) && require(dplyr) && require(magrittr)) {

  ## dataset to create a linelist from
  head(measles_hagelloch_1861)

  ## create linelist
  x <- measles_hagelloch_1861 \%>\%
    tibble() \%>\% 
    make_linelist(id = "case_ID",
                  date_onset = "date_of_prodrome",
                  age = "age",
                  gender = "gender")
  x

  ## change select all dates and some tags
  x \%>\%
    select(contains("date"), tags = c("id", "age", "gender"))

  ## showing warnings when tags are lost
  x \%>\%
    select(1:3)

 ## getting rid of warnings on the fly
 x \%>\%
   lost_tags_action("none") \%>\%
   select(1:3)

 ## reset default behaviour
 lost_tags_action()

}
}
\seealso{
\itemize{
\item \code{\link[=select_tags]{select_tags()}} to select tags only
\item \code{\link[=tags_df]{tags_df()}} to return a \code{data.frame} of all tagged variables
}
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
