% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{augment.lineqDGP}
\alias{augment.lineqDGP}
\title{Augmenting Method for the \code{"lineqDGP"} S3 Class}
\usage{
\method{augment}{lineqDGP}(x, ...)
}
\arguments{
\item{x}{an object with class \code{lineqDGP}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An expanded \code{"lineqDGP"} object with the following additional elements.
\item{Phi}{a matrix corresponding to the hat basis functions.
The basis functions are indexed by rows.}
\item{Gamma}{the covariance matrix of the Gassian vector \eqn{\boldsymbol{\xi}}{\xi}.}
\item{(Lambda,lb,ub)}{the linear system of inequalities.}
\item{...}{further parameters passed to or from other methods.}
}
\description{
Augmenting method for the \code{"lineqDGP"} S3 class.
}
\examples{
# creating the model
sigfun <- function(x) return(1/(1+exp(-7*(x-0.5))))
x <- seq(0, 1, length = 5)
y <- sigfun(x)
model <- create(class = "lineqDGP", x, y, constrType = "monotonicity")

# updating and expanding the model
model$localParam$m <- 30
model$kernParam$par <- c(1, 0.2)
model2 <- augment(model)
image(model2$Gamma, main = "covariance matrix")

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{create.lineqDGP}}, \code{\link{predict.lineqDGP}}, \code{\link{simulate.lineqDGP}}
}
\author{
A. F. Lopez-Lopera.
}
