% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGP.R
\name{augment.lineqGP}
\alias{augment.lineqGP}
\title{Augmenting Method for the \code{"lineqGP"} S3 Class}
\usage{
\method{augment}{lineqGP}(x, ...)
}
\arguments{
\item{x}{an object with class \code{lineqGP}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An expanded \code{"lineqGP"} object with the following additional elements.
\item{Phi}{a matrix corresponding to the hat basis functions.
The basis functions are indexed by rows.}
\item{Gamma}{the covariance matrix of the Gassian vector \eqn{\boldsymbol{\xi}}{\xi}.}
\item{(Lambda,lb,ub)}{the linear system of inequalities.}
\item{...}{further parameters passed to or from other methods.}
}
\description{
Augmenting method for the \code{"lineqGP"} S3 class.
}
\details{
Some paramaters of the finite-dimensional GP with linear inequality
constraints are computed. Here, \eqn{\boldsymbol{\xi}}{\xi} is a centred Gaussian
vector with covariance \eqn{\boldsymbol{\Gamma}}{\Gamma}, s.t.
\eqn{\boldsymbol{\Phi} \boldsymbol{\xi} = \boldsymbol{y}}{\Phi \xi = y}
(interpolation constraints) and
\eqn{\boldsymbol{l} \leq \boldsymbol{\Lambda} \boldsymbol{\xi} \leq \boldsymbol{u}}{lb \le \Lambda \xi \le ub}
(inequality constraints).
}
\examples{
# creating the model
sigfun <- function(x) return(1/(1+exp(-7*(x-0.5))))
x <- seq(0, 1, length = 5)
y <- sigfun(x)
model <- create(class = "lineqGP", x, y, constrType = "monotonicity")

# updating and expanding the model
model$localParam$m <- 30
model$kernParam$par <- c(1, 0.2)
model2 <- augment(model)
image(model2$Gamma, main = "covariance matrix")

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2017),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1710.07453}{[link]}
}
\seealso{
\code{\link{create.lineqGP}}, \code{\link{predict.lineqGP}},
         \code{\link{simulate.lineqGP}}
}
\author{
A. F. Lopez-Lopera.
}
