% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lma_termcat.R
\name{lma_termcat}
\alias{lma_termcat}
\title{Document-Term Matrix Categorization}
\usage{
lma_termcat(dtm, dict, term.weights = NULL, bias = NULL,
  bias.name = "_intercept", escape = TRUE, partial = FALSE,
  glob = TRUE, term.filter = NULL, term.break = 20000,
  to.lower = FALSE, dir = getOption("lingmatch.dict.dir"))
}
\arguments{
\item{dtm}{A matrix with terms as column names.}

\item{dict}{The name of a provided dictionary
(\href{https://osf.io/y6g5b/wiki/home}{osf.io/y6g5b/wiki}) or of a file found in
\code{dir}, or a \code{list} object with named character vectors as word lists,
or the path to a file to be read in by \code{\link{read.dic}}.}

\item{term.weights}{A \code{list} object with named numeric vectors lining up with the character
vectors in \code{dict}, used to weight the terms in each \code{dict} vector. If a category in
\code{dict} is not specified in \code{term.weights}, or the \code{dict} and \code{term.weights}
vectors aren't the same length, the weights for that category will be 1.}

\item{bias}{A list or named vector specifying a constant to add to the named category. If a term
matching \code{bias.name} is included in a category, it's associated \code{weight} will be used
as the \code{bias} for that category.}

\item{bias.name}{A character specifying a term to be used as a category bias; default is
\code{'_intercept'}.}

\item{escape}{Logical indicating whether the terms in \code{dict} should not be treated as plain
text (including asterisk wild cards). If \code{TRUE}, regular expression related characters are
escaped. Set to \code{TRUE} if you get PCRE compilation errors.}

\item{partial}{Logical; if \code{TRUE} terms are partially matched (not padded by ^ and $).}

\item{glob}{Logical; if \code{TRUE} (default), will convert initial and terminal asterisks to
partial matches.}

\item{term.filter}{A regular expression string used to format the text of each term (passed to
\code{gsub}). For example, if terms are part-of-speech tagged (e.g.,
\code{'a_DT'}), \code{'_.*'} would remove the tag.}

\item{term.break}{If a category has more than \code{term.break} characters, it will be processed
in chunks. Reduce from 20000 if you get a PCRE compilation error.}

\item{to.lower}{Logical; if \code{TRUE} will lowercase dictionary terms. Otherwise, dictionary
terms will be converted to match the terms if they are single-cased. Set to \code{FALSE} to
always keep dictionary terms as entered.}

\item{dir}{Path to a folder in which to look for \code{dict}; \cr
will look in \code{'~/Dictionaries'} by default. \cr
Set a session default with \code{options(lingmatch.dict.dir = 'desired/path')}.}
}
\value{
A matrix with a row per \code{dtm} row and columns per dictionary category, and a \code{WC} attribute
with original word counts.
}
\description{
Reduces the dimensions of a document-term matrix by dictionary-based categorization.
}
\examples{
\dontrun{

# Score texts with the NRC Affect Intensity Lexicon

dict <- readLines("https://saifmohammad.com/WebDocs/NRC-AffectIntensity-Lexicon.txt")
dict <- read.table(
  text = dict[-seq_len(grep("term\tscore", dict, fixed = TRUE)[[1]])],
  col.names = c("term", "weight", "category")
)

text <- c(
  angry = paste(
    "We are outraged by their hateful brutality,",
    "and by the way they terrorize us with their hatred."
  ),
  fearful = paste(
    "The horrific torture of that terrorist was tantamount",
    "to the terrorism of terrorists."
  ),
  joyous = "I am jubilant to be celebrating the bliss of this happiest happiness.",
  sad = paste(
    "They are nearly suicidal in their mourning after",
    "the tragic and heartbreaking holocaust."
  )
)

emotion_scores <- lma_termcat(text, dict)
if (require("splot")) splot(emotion_scores ~ names(text), leg = "out")

## or use the standardized version (which includes more categories)

emotion_scores <- lma_termcat(text, "nrc_eil", dir = "~/Dictionaries")
emotion_scores <- emotion_scores[, c("anger", "fear", "joy", "sadness")]
if (require("splot")) splot(emotion_scores ~ names(text), leg = "out")
}
}
\seealso{
For applying pattern-based dictionaries (to raw text) see \code{\link{lma_patcat}}.

Other Dictionary functions: 
\code{\link{download.dict}()},
\code{\link{lma_patcat}()},
\code{\link{read.dic}()},
\code{\link{select.dict}()}
}
\concept{Dictionary functions}
