% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkGDAL.R
\name{linkGDAL}
\alias{linkGDAL}
\title{Checks and sets up via \code{gdalUtils}  the 'GDAL' pathes and settings for the command line usage.}
\usage{
linkGDAL(quiet = TRUE, returnPaths = TRUE)
}
\arguments{
\item{quiet}{boolean  switch for supressing console messages default is TRUE}

\item{returnPaths}{boolean if set to FALSE the GDAL binary path is written 
to the PATH variable only, otherwise all paths and names of the installed "GDAL" ae returned.}
}
\description{
For almost all GI related software tools you need to have installed the  \href{http://www.gdal.org/}{'GDAL'}  binaries. It is useful for checking and linking the 'GDAL' binary 
installation to the 'R'environment for command line calls of GDAL functions.  \code{linkGDAL} checks
via \code{gdalUtils} the status of the 'GDAL' binaries installation.
}
\examples{
\dontrun{

# get all available GDAL informations 
gdal<-linkGDAL()
if (nchar(gdal[[1]][[1]])>0) {
# get available GDAL driver
gdal[[1]]$drivers$format_code

# get the binary path (is also written to the PATH variable)
gdal[[1]]$path

# get the available python tools e.g. for gdal_sieve.py
# you may call it like following:
#  ret <- system(paste0("gdal_sieve.py -8 ",
#                         "input.sdat ",
#                         "output.sdat ",
#                         "-of SAGA"), intern = TRUE)
gdal[[1]]$python_utilities

}
}
}
\author{
Chris Reudenbach
}
